package cn.com.duiba.tuia.activity.center.api.constant.commercial.mission;

import java.util.Objects;

/**
 * [商业化活动]任务条件类型枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public enum MissionConditionType {

    LOGIN(1, "LOGIN", "登录", 0, "天"),
    PLANT(2, "PLANT", "种红包", 1, "次"),
    PICK(3, "PICK", "收红包", 1, "次"),
    CONTINUOUS_LOGIN(4, "CONTINUOUS_LOGIN", "连续登录", 0, "天"),
    DIG(5, "DIG", "挖矿", 2, "次"),
    ENTER_MINE_CAVE(6, "ENTER_MINE_CAVE", "进入矿洞", 2, "层"),
    OPEN_TREASURE_BOX(7, "OPEN_TREASURE_BOX", "开启宝箱", 2, "个"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    /**
     * 活动类型（0.通用; 1.种红包; 2.挖矿）
     */
    private Integer bizActivityType;

    /**
     * 数量单位
     */
    private String amountUnit;

    MissionConditionType(Integer type, String key, String desc, Integer bizActivityType, String amountUnit) {
        this.type = type;
        this.key = key;
        this.desc = desc;
        this.bizActivityType = bizActivityType;
        this.amountUnit = amountUnit;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getBizActivityType() {
        return bizActivityType;
    }

    public String getAmountUnit() {
        return amountUnit;
    }

    /**
     * 获取任务的枚举
     *
     * @param key 任务类型键名
     * @return 枚举
     */
    public static MissionConditionType getByKey(String key) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param key 任务类型键名
     * @return 类型
     */
    public static Integer getTypeByKey(String key) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum.getType();
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param type 任务类型
     * @return 任务类型键名
     */
    public static String getKeyByType(Integer type) {
        for (MissionConditionType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getKey();
            }
        }
        return null;
    }
}
