package cn.com.duiba.tuia.activity.center.api.constant.commercial.mission;

import java.util.Objects;

/**
 * [商业化活动]任务奖励枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public enum MissionPrizeType {

    CASH(1, "CASH", "现金", 0),
    LAND_UNLOCK(2, "LAND_UNLOCK", "解锁土地", 1),
    CORN_UNLOCK(3, "CORN_UNLOCK", "解锁玉米", 1),
    PUMPKIN_UNLOCK(4, "PUMPKIN_UNLOCK", "解锁南瓜", 1),
    PITAYA_UNLOCK(5, "PITAYA_UNLOCK", "解锁火龙果", 1),
    BLOCK(6, "BLOCK", "虚拟奖品", 0),
    ENCOURAGE(7, "ENCOURAGE", "触发增值广告", 0),
    VIDEO(8, "VIDEO", "视频激励广告", 0),
    FIRST_PRIZE(9, "FIRST_PRIZE", "新手红包", -1),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 键名
     */
    private String key;

    /**
     * 描述
     */
    private String  desc;

    /**
     * 活动类型（0.通用; 1.种红包; 2.挖矿）
     */
    private Integer bizActivityType;

    MissionPrizeType(Integer type, String key, String desc, Integer bizActivityType) {
        this.type = type;
        this.key = key;
        this.desc = desc;
        this.bizActivityType = bizActivityType;
    }

    public Integer getType() {
        return type;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getBizActivityType() {
        return bizActivityType;
    }

    /**
     * 获取奖励的枚举
     *
     * @param key 奖励类型键名
     * @return 枚举
     */
    public static MissionPrizeType getByKey(String key) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param key 任务类型键名
     * @return 类型
     */
    public static Integer getTypeByKey(String key) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getKey(), key)) {
                return typeEnum.getType();
            }
        }
        return null;
    }

    /**
     * 获取任务的类型
     *
     * @param key 任务类型键名
     * @return 类型
     */
    public static String getKeyByType(Integer type) {
        for (MissionPrizeType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getKey();
            }
        }
        return null;
    }
}
