/**
 * Project Name:activity-center-api<br>
 * File Name:Prob.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.dto<br>
 * Date:2017年3月29日下午8:54:03<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.activity.center.api.dto;

import cn.com.duiba.tuia.activity.center.api.common.BaseDto;
import cn.com.duiba.tuia.activity.center.api.common.Probability;
import cn.com.duiba.tuia.activity.center.api.constant.PageType;
import org.apache.commons.lang3.RandomUtils;

import java.util.List;

/**
 * ClassName: ProbDto <br/>
 * Function: 浮标跳转概率Dto. <br/>
 * Reason: . <br/>
 * date: 2017年3月29日 下午8:54:03 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class ProbDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /** 配置表的id */
    private Long id;

    /** actCenter:活动中心 概率. */
    private Probability       actCenter;
    /** mainMeet:主会场 概率. */
    private Probability       mainMeet;
    /** activity:活动 概率. */
    private Probability       activity;
    /** 直达变现页 概率.*/
    private Probability       directPage;
    /** 广告 概率. */
    private Probability       advert;

    /** url:活动 概率. */
    private Probability       url;

    /** 安卓 url **/
    private List<RateDto> urlList;

    /** ios url **/
    private List<RateDto> iosUrlList;

    /** 配置推荐位-主会场页面概率.*/
    private List<RateDto> mainMeetList;

    /* 配置推荐位-活动页面概率 */
    private List<RateDto> activityList;

    /** 落地页url对应浮标. */
    private List<Long> buoyIdList;

    /** 配置直投页列表面概率.*/
    private List<RateDto> directPageList;

    /** 广告对应的浮标.*/
    private List<Long> advertBuoyIdList;

    /** 广告对应的浮标详情.*/
    private List<RateDto> advertBuoyDetailList;

    /** 投放广告的定向模式 */
    private Integer directModel;

    /** 投放广告的广告 */
    private List<Long> advertIds;

    /** 是否开启定制 */
    private Integer isDirectAdvert;

    /** 广告位列表 */
    private String advertsLocation;

    /** 浮标标题 */
    private String buoyTitle;

    /** 活动中心 浮标ID  一般为下拉*/
    private Long actCenterBuoyId;

    /** 活动中心 浮标名称  一般为下拉*/
    private String actCenterBuoyName;

    /** 人群包英文*/
    private String peopleTag;

    /** 人群包名称*/
    private String peopleTagName;

    public ProbDto() {
        super();
    }

    /**
     * 根据概率返回RateDto
     * @param list list
     * @param totalRate 总概率，没有则遍历list计算
     * @return RateDto
     */
    public static RateDto calRate(List<RateDto> list,Integer totalRate) {
        if (list == null || list.isEmpty()) {
            return null;
        }

        Integer total = totalRate;

        if (total == null) {
            total = sumRate(list);
        }

        if (total == null || total == 0) {
            return null;
        }

        int point = RandomUtils.nextInt(0, total) + 1;

        for (RateDto dto : list) {
            Integer rate = dto.getRate();
            if (rate == null || rate == 0) {
                continue;
            }
            if (rate >= point) {
                return dto;
            } else {
                point-=rate;
            }
        }
        return null;
    }

    /**
     * 计算概率和
     * @param list list
     * @return 概率和
     */
    public static Integer sumRate(List<RateDto> list) {
        int total = 0;
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (RateDto dto : list) {
            Integer rate = dto.getRate();
            if (rate != null) {
                total += rate;
            }

        }
        return total;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Long> getBuoyIdList() {
        return buoyIdList;
    }

    public void setBuoyIdList(List<Long> buoyIdList) {
        this.buoyIdList = buoyIdList;
    }

    public Probability getUrl() {
        return url;
    }

    public void setUrl(Probability url) {
        this.url = url;
    }

    public List<RateDto> getUrlList() {
        return urlList;
    }

    public void setUrlList(List<RateDto> urlList) {
        this.urlList = urlList;
    }

    public List<RateDto> getIosUrlList() {
        return iosUrlList;
    }

    public void setIosUrlList(List<RateDto> iosUrlList) {
        this.iosUrlList = iosUrlList;
    }

    public List<RateDto> getMainMeetList() {
        return mainMeetList;
    }

    public void setMainMeetList(List<RateDto> mainMeetList) {
        this.mainMeetList = mainMeetList;
    }

    public List<RateDto> getActivityList() {
        return activityList;
    }

    public void setActivityList(List<RateDto> activityList) {
        this.activityList = activityList;
    }

    public Probability getActCenter() {
        return actCenter;
    }

    public void setActCenter(Probability actCenter) {
        this.actCenter = actCenter;
    }

    public Probability getMainMeet() {
        return mainMeet;
    }

    public void setMainMeet(Probability mainMeet) {
        this.mainMeet = mainMeet;
    }

    public Probability getActivity() {
        return activity;
    }

    public void setActivity(Probability activity) {
        this.activity = activity;
    }

    public Probability getDirectPage() {
        return directPage;
    }

    public void setDirectPage(Probability directPage) {
        this.directPage = directPage;
    }

    public List<RateDto> getDirectPageList() {
        return directPageList;
    }

    public void setDirectPageList(List<RateDto> directPageList) {
        this.directPageList = directPageList;
    }

    public Probability getAdvert() {
        return advert;
    }

    public void setAdvert(Probability advert) {
        this.advert = advert;
    }


    public Integer getDirectModel() {
        return directModel;
    }

    public void setDirectModel(Integer directModel) {
        this.directModel = directModel;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    public List<Long> getAdvertBuoyIdList() {
        return advertBuoyIdList;
    }

    public void setAdvertBuoyIdList(List<Long> advertBuoyIdList) {
        this.advertBuoyIdList = advertBuoyIdList;
    }

    public List<RateDto> getAdvertBuoyDetailList() {
        return advertBuoyDetailList;
    }

    public Integer getIsDirectAdvert() {
        return isDirectAdvert;
    }

    public void setIsDirectAdvert(Integer isDirectAdvert) {
        this.isDirectAdvert = isDirectAdvert;
    }

    public void setAdvertBuoyDetailList(List<RateDto> advertBuoyDetailList) {
        this.advertBuoyDetailList = advertBuoyDetailList;
    }

    public String getAdvertsLocation() {
        return advertsLocation;
    }

    public void setAdvertsLocation(String advertsLocation) {
        this.advertsLocation = advertsLocation;
    }

    public String getBuoyTitle() {
        return buoyTitle;
    }

    public void setBuoyTitle(String buoyTitle) {
        this.buoyTitle = buoyTitle;
    }

    public Long getActCenterBuoyId() {
        return actCenterBuoyId;
    }

    public void setActCenterBuoyId(Long actCenterBuoyId) {
        this.actCenterBuoyId = actCenterBuoyId;
    }

    public String getActCenterBuoyName() {
        return actCenterBuoyName;
    }

    public void setActCenterBuoyName(String actCenterBuoyName) {
        this.actCenterBuoyName = actCenterBuoyName;
    }

    public String getPeopleTag() {
        return peopleTag;
    }

    public void setPeopleTag(String peopleTag) {
        this.peopleTag = peopleTag;
    }

    public String getPeopleTagName() {
        return peopleTagName;
    }

    public void setPeopleTagName(String peopleTagName) {
        this.peopleTagName = peopleTagName;
    }

    public boolean isSuitable(Integer persent) {
        int suitable = persent == null ? 100 : persent;
        if (actCenter != null && mainMeet != null && directPage != null ) {
            int percent = actCenter.intPercentValue() + mainMeet.intPercentValue()+ directPage.intPercentValue();
            if(null != url){
                percent += url.intPercentValue();
            }
            if (activity != null) {
                percent += activity.intPercentValue();
            }
            if(null != advert){
                percent += advert.intPercentValue();
            }
            return percent == suitable;
        }
        return false;
    }

    /***
         * @Description: isSuitableMainMeetList 判断主会场概率是否正确
         *
         * @Param: []
         * @Return: boolean
         * @throws:
         * @author: youhaijun
         * @Date:   2017/8/15
         */
    public boolean isSuitableMainMeetList()
    {
        if (0 != mainMeet.intPercentValue()){
            if(null == mainMeetList || mainMeetList.isEmpty()){
                return false;
            }
            int percent = 0;
            for(RateDto dto : mainMeetList){
                percent += dto.getRate();
            }
            if (100 == percent){
                return true;
            }
        }
        return false;
    }

    /**
     * selectMaxProbability:(查询概率最大的). <br/>
     * @return
     */
    public Integer selectMaxProbability() {
        int acp = 0;
        int ap = 0;
        int mp = 0;
        if (actCenter != null) {
            acp = actCenter.intPercentValue();
        }
        if (activity != null) {
            ap = activity.intPercentValue();
        }
        if (mainMeet != null) {
            mp = mainMeet.intPercentValue();
        }

        PageType rs = PageType.ACTIVITY;
        if (acp > ap) {
            rs = PageType.ACTCENTER;
            if (mp > acp) {
                rs = PageType.MAINMEET;
            }

        } else if (mp > ap) {
            rs = PageType.MAINMEET;
        }
        return rs.getCode();
    }
}
