/**
 * Project Name:activity-center-api<br>
 * File Name:RemoteBuoyService.java<br>
 * Package Name:cn.com.duiba.tuia.activity.center.api.remoteservice<br>
 * Date:2017年3月29日下午4:00:46<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */
package cn.com.duiba.tuia.activity.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.common.PageDto;
import cn.com.duiba.tuia.activity.center.api.constant.EntranceType;
import cn.com.duiba.tuia.activity.center.api.dto.BuoyDataDto;
import cn.com.duiba.tuia.activity.center.api.dto.BuoyDto;
import cn.com.duiba.tuia.activity.center.api.dto.ProbConfigDto;
import cn.com.duiba.tuia.activity.center.api.dto.ProbDto;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.Date;
import java.util.List;


/**
 * ClassName: RemoteBuoyService <br/>
 * Function: 浮标接口. <br/>
 * Reason: . <br/>
 * date: 2017年3月29日 下午4:00:46 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteBuoyService {
    /**
     * saveBuoy:(保存). <br/>
     * @param dto
     * @return
     */
    DubboResult<Long> saveBuoy(BuoyDto dto);
    
    /**
     * selectList:(查询). <br/>
     * @param start
     * @param end
     * @param offset
     * @param max
     * @return
     */
    DubboResult<PageDto<BuoyDataDto>> selectList(Date start,Date end,Integer offset,Integer max);

    /**
         * @Description: selectList 查询列表 支持id和title
         *
         * @Param: [id, title, start, end, offset, max]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<cn.com.duiba.tuia.activity.center.api.common.PageDto<cn.com.duiba.tuia.activity.center.api.dto.BuoyDataDto>>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/16
         */
    @Deprecated
    @RequestMapping("selectListId")
    DubboResult<PageDto<BuoyDataDto>> selectList(Long id, String title, Date start, Date end, Integer offset, Integer max);

    /**
     * 查询浮标列表
     *
     * @param id 样式ID
     * @param title 样式名称
     * @param buoyType 浮标类型
     * @param start 开始时间
     * @param end 结束时间
     * @param offset 偏移量
     * @param max 页长
     * @return 浮标分页数据
     */
    @RequestMapping("selectBuoyList")
    DubboResult<PageDto<BuoyDataDto>> selectList(Long id, String title, Integer buoyType, Date start, Date end, Integer offset, Integer max);

    @RequestMapping("selectBuoyListNew")
    PageDto<BuoyDataDto> selectList(BuoyDto dto, Date start,Date end,Integer offset,Integer max);

    /**
     * selectAll:(查询所有). <br/>
     * @return
     */
    DubboResult<List<BuoyDto>> selectAll();


    /**
     * deleteBuoy:(删除). <br/>
     * @param id
     * @return
     */
    DubboResult<Boolean> deleteBuoy(Long id);
    
    /**
     * selectById:(根据id查询). <br/>
     * @param id
     * @return
     */
    DubboResult<BuoyDto> selectById(Long id);
    
    /**
     * selectProb:(查概率). <br/>
     * @return
     */
    DubboResult<ProbDto> selectProb(EntranceType type);


    /**
     * selectProb:(查概率). <br/>
     * @return
     */
    DubboResult<ProbDto> selectProbById(EntranceType type,Long id);
    
    /**
     * saveProb:(保存). <br/>
     * @param type
     * @return
     */
    DubboResult<Boolean> saveProb(EntranceType type,ProbDto dto);

    /**
         * @Description: 修改浮标开启关闭状态
         *
         * @Param: [id, isOpen]
         * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.lang.Boolean>
         * @throws:
         * @author: youhaijun
         * @Date:   2017/6/14
         */
    DubboResult<Boolean> updateBuoyOpenStatus(Long id, Boolean isOpen);
/**
     * @Description: selectOpenList 查询开启浮标列表
     *
     * @Param: []
     * @Return: cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.activity.center.api.dto.BuoyDto>>
     * @throws:
     * @author: youhaijun
     * @Date:   2017/6/14
     */
    DubboResult<List<BuoyDto>> selectOpenList();

    /**
     * 查询指定类型的开启浮标列表
     *
     * @param buoyType 浮标类型
     * @return 开启浮标列表
     */
    DubboResult<List<BuoyDto>> selectOpenListByType(Integer buoyType);

    /**
     * selectByIds:(根据ids查询). <br/>
     * @param ids
     * @return
     */
    DubboResult<List<BuoyDto>> selectByIds(List<Long> ids);

    /**
     * 查询列表
     * @param offset
     * @param max
     * @return
     */
    @RequestMapping("selectListByTuiaKey")
    DubboResult<PageDto<ProbConfigDto>> selectListByTuiaKey(Integer offset, Integer max);

    /**
     * 查询列表
     * @param offset
     * @param max
     * @return
     */
    @RequestMapping("selectListByTuiaKeyAndType")
    DubboResult<PageDto<ProbConfigDto>> selectListByTuiaKey(Integer offset, Integer max,EntranceType type);

    /**
     * 根据主键删除
     * 用于浮标定制
     * @return
     */
    DubboResult<Boolean> deleteByPrimaryKey(Long id);


    /**
     * 根据主键删除
     * 用于定向人群包
     * @return
     */
    DubboResult<Boolean> deleteConfigAndPeopleTagByPrimaryKey(Long id);

}
