/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.activity.usercenter.api.util;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;

public class MathUtil {
    private static final int MULTIPLIER = 100;

    private MathUtil() {
    }

    public static String yuan2Fen(String yuan) throws ParseException {
        NumberFormat format = NumberFormat.getInstance();
        Number number = format.parse(yuan);
        double temp = number.doubleValue() * 100.0;
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(0);
        return format.format(temp);
    }

    public static String yuan2Fen(int yuan) {
        NumberFormat format = NumberFormat.getInstance();
        double temp = (double)yuan * 100.0;
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(0);
        return format.format(temp);
    }

    public static String fen2Yuan(String fen) {
        return new BigDecimal(fen).divide(new BigDecimal(100)).setScale(2).toString();
    }

    public static String fen2Yuan(int fen) {
        return new BigDecimal(fen).divide(new BigDecimal(100)).setScale(2).toString();
    }

    public static String exchangeRate2a(String rate, double bValue) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(0);
        format.setGroupingUsed(false);
        double temp = bValue * Double.valueOf(rate);
        return format.format(temp);
    }

    public static String exchangeRate2b(String rate, long aValue) {
        return new BigDecimal(aValue).divide(new BigDecimal(rate)).setScale(4).toString();
    }
}

