package cn.com.duiba.tuia.activity.usercenter.api.constant;


/**
 * ClassName: LoginType <br/>
 * Function: 登录类型枚举. <br/>
 * Reason: 用来区分不同的登录状态. <br/>
 * date: 2017年2月24日 下午2:11:12 <br/>
 *
 * @author wubo
 * @version 
 * @since JDK 1.7
 */
public enum LoginType {
    
    NORMAL("normal","正常访问"),
    PREVIEW("preview","预览访问");
    
    /** code:登录类型.*/
    private String code;

    /** desc:登录类型描述.*/
    private String desc;
    
    private LoginType(String code,String desc){
        this.code = code;
        this.desc = desc;
    }
    
    /**
     * getCode. <br/>
     * @return
     */
    public String getCode() {
        return code;
    }

    /**
     * getDesc. <br/>
     * @return
     */
    public String getDesc() {
        return desc;
    }
    
    /**
     * equalsCode:(equals code). <br/>
     * @param code
     * @return boolean
     */
    public boolean equalsCode(String code){
        return this.code.equals(code);
    }
}
