package cn.com.duiba.tuia.core.api.enums.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.core.api.dto.statistics.TitleHeader;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AdvertAppStatisticsTitleEnum <br/>
 * Function: 每日广告应用数据标题. <br/>
 * date: 2018年4月20日 下午2:15:47 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertAppStatisticsTitleEnum {

    /** 应用ID */
    APP_ID(0, "appId", "应用ID"),
    
    /** 应用名称 */
    APP_NAME(0, "name", "应用名称"),
    
    /** 应用标签 */
    TAG_NAME(0, "tagName", "应用标签"),
    
    /** 应用来源 */
    APP_SOURCE(0, "appSource", "应用来源"),
    
    /** 当前状态 */
    APP_STATUS(1, "appStatus", "当前状态"),
    
    /** 成本变化 */
    COST_CHANGE(1, "costChange", "成本变化"),
    
    /** 消费 */
    CONSUME_TOTAL(0, "consumeTotal", "消费"),
    
    /** 发券 */
    LAUNCH_COUNT(0, "launchCount", "发券"),
    
    /** 曝光 */
    EXPOSURE_COUNT(0, "exposureCount", "曝光"),
    
    /** 总点击 */
    CLICK_COUNT(0, "clickCount", "总点击"),
    
    /** 计费点击 */
    EF_CLICK_COUNT(0, "efClickCount", "计费点击"),
    
    /** 计费点击UV */
    CLICK_UV(0, "clickUV", "计费点击UV"),
    
    /** 成本 */
    COST(0, "cost", "成本"),
    
    /** 计费点击率 */
    CLICK_RATE(0, "clickRate", "计费点击率"),
    
    /** 落地页访问PV/UV */
    VISIT_PV_UV(1, "visitPvUv", "落地页访问PV/UV"),
    
    /** 落地页访问PV */
    VISIT_PV(2, "visitPv", "落地页访问PV"),
    
    /** 落地页访问UV */
    VISIT_UV(2, "visitUv", "落地页访问UV"),
    
    /** 落地页到达率 */
    LOSS(0, "loss", "落地页到达率"),
    
    /** 转化PV/UV */
    EFFECT_PV_UV(1, "effectPvUv", "转化PV/UV"),
    
    /** 转化PV */
    EFFECT_PV(2, "effectPv", "转化PV"),
    
    /** 转化UV */
    EFFECT_UV(2, "effectUv", "转化UV"),
    
    /** CVR */
    CVR(0, "cvr", "CVR"),
    
    /** 计费点击均价 */
    AVERAGE_PRICE(3, "averagePrice", "计费点击均价");

    /** 类型：0-公用，1-页面展示标题，2-导出标题,3-后面追加 */
    private Integer type;
    
    private String code;

    private String desc;
  
    private AdvertAppStatisticsTitleEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    public static AdvertAppStatisticsTitleEnum getByCode(String code) {
        return enumMap.get(code);
    }
    

    private static Map<String, AdvertAppStatisticsTitleEnum> enumMap = Maps.newHashMap();
    /** 固定数据标题 */
    private static List<TitleHeader> advertAppStatisticsTitleList = new ArrayList<>(AdvertAppStatisticsTitleEnum.values().length*2);
    private static List<TitleHeader> advertAppStatisticsExporyTitleList = new ArrayList<>(AdvertAppStatisticsTitleEnum.values().length*2);
    static {
        for (AdvertAppStatisticsTitleEnum it : AdvertAppStatisticsTitleEnum.values()) {
            enumMap.put(it.getCode(), it);
            switch (it.type) {
                case 0:
                    advertAppStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    advertAppStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 1:
                    advertAppStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 2:
                    advertAppStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 
     * getAdvertAppStatisticsTitle:(获取转化标题前固定标题，1-展示，2-导出). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    public static List<TitleHeader> getAdvertAppStatisticsTitle(Integer type) {
        if (type.intValue() == 1) {
            return BeanUtils.copyList(advertAppStatisticsTitleList, TitleHeader.class);
        }else{
            return BeanUtils.copyList(advertAppStatisticsExporyTitleList, TitleHeader.class);
        }
    }
    
    /**
     * 
     * addOtherTitle:(其他标题追加，转化数据标题放在这些标题之前). <br/>
     *
     * @author chencheng
     * @param advertAppStatisticsTitle
     * @since JDK 1.8
     */
    public static void addOtherTitle(List<TitleHeader> advertAppStatisticsTitle) {
        
        advertAppStatisticsTitle.add(new TitleHeader(AVERAGE_PRICE.code, AVERAGE_PRICE.desc));
    }
}
