package cn.com.duiba.tuia.core.api.enums.statistics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.core.api.dto.statistics.TitleHeader;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.collect.Maps;

/**
 * ClassName: AdvertDayStatisticsTitleEnum <br/>
 * Function: 每日广告数据标题. <br/>
 * date: 2018年4月20日 下午2:15:41 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertDayStatisticsTitleEnum {

    /** 日期 */
    CUR_DATE(0, "curDate", "日期"),
    
    /** 广告状态名称 */
    VALID_STATUS_NAME(0, "validStatusName", "当日广告状态"),
    
    /** 消费/预算 */
    BUDGET_CONSUME_TOTAL(1, "budgetConsumeTotal", "消费/预算"),
    
    /** 消费 */
    CONSUME_TOTAL(2, "consumeTotal", "消费"),
    
    /** 预算 */
    BUDGET(2, "budget", "预算"),
    
    /** 发券 */
    LAUNCH_COUNT(0, "launchCount", "发券"),
    
    /** 曝光 */
    EXPOSURE_COUNT(0, "exposureCount", "曝光"),
    
    /** 总点击 */
    CLICK_COUNT(0, "clickCount", "总点击"),
    
    /** 计费点击 */
    EF_CLICK_COUNT(0, "efClickCount", "计费点击"),
    
    /** 计费点击UV */
    CLICK_UV(0, "clickUV", "计费点击UV"),
    
    /** 计费点击率 */
    CLICK_RATE(0, "clickRate", "计费点击率"),
    
    /** 落地页访问PV/UV */
    VISIT_PV_UV(1, "visitPvUv", "落地页访问PV/UV"),
    
    /** 落地页访问PV */
    VISIT_PV(2, "visitPv", "落地页访问PV"),
    
    /** 落地页访问UV */
    VISIT_UV(2, "visitUv", "落地页访问UV"),
    
    /** 落地页到达率 */
    LOSS(0, "loss", "落地页到达率"),
    
    /** 转化PV/UV */
    EFFECT_PV_UV(1, "effectPvUv", "转化PV/UV"),
    
    /** 转化PV */
    EFFECT_PV(2, "effectPv", "转化PV"),
    
    /** 转化UV */
    EFFECT_UV(2, "effectUv", "转化UV"),
    
    /** 转化成本（PV）消耗/转化pv */
    EFFECT_COST(0, "effectCost", "转化成本（PV）"),
    
    /** CVR */
    CVR(0, "cvr", "CVR"),
    
    /** 实际消费 */
    CORRECTION_TOTAL(3, "correctionTotal", "实际消费"),
    
    /** 计费点击均价 */
    AVERAGE_PRICE(3, "averagePrice", "计费点击均价");
    
    /** 类型：0-公用，1-页面展示标题，2-导出标题,3-后面追加 */
    private Integer type;
    
    private String code;

    private String desc;
    
    private AdvertDayStatisticsTitleEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    /**
     * type.
     *
     * @return  the type
     * @since   JDK 1.8
     */
    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, AdvertDayStatisticsTitleEnum> enumMap = Maps.newHashMap();
    /** 固定数据标题 */
    private static List<TitleHeader> advertDayStatisticsTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length*2);
    private static List<TitleHeader> advertDayStatisticsExporyTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length*2);
    static {
        for (AdvertDayStatisticsTitleEnum it : AdvertDayStatisticsTitleEnum.values()) {
            enumMap.put(it.getCode(), it);
            switch (it.type) {
                case 0:
                    advertDayStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    advertDayStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 1:
                    advertDayStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 2:
                    advertDayStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 
     * getAdvertDayStatisticsTitle:(获取转化标题前固定标题，1-展示，2-导出). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    public static List<TitleHeader> getAdvertDayStatisticsTitle(Integer type) {
        if (type.intValue() == 1) {
            return BeanUtils.copyList(advertDayStatisticsTitleList, TitleHeader.class);
        }else{
            return BeanUtils.copyList(advertDayStatisticsExporyTitleList, TitleHeader.class);
        }
    }
    

    public static AdvertDayStatisticsTitleEnum getByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * 
     * addOtherTitle:(其他标题追加，转化数据标题放在这些标题之前). <br/>
     *
     * @author chencheng
     * @param advertDayStatisticsTitle
     * @since JDK 1.8
     */
    public static void addOtherTitle(List<TitleHeader> advertDayStatisticsTitle) {
        
        advertDayStatisticsTitle.add(new TitleHeader(CORRECTION_TOTAL.code, CORRECTION_TOTAL.desc));
        advertDayStatisticsTitle.add(new TitleHeader(AVERAGE_PRICE.code, AVERAGE_PRICE.desc));
    }
    
    
}
