package cn.com.duiba.tuia.core.api.remoteservice.finance;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.finance.AccountFinanceInvoiceDto;
import cn.com.duiba.tuia.core.api.dto.finance.AgentCashOutDto;
import cn.com.duiba.tuia.core.api.dto.finance.AgentInvoiceStatisticsDataDto;
import cn.com.duiba.tuia.core.api.dto.finance.InvoiceHistoryReq;
import cn.com.duiba.tuia.core.api.dto.finance.MonthCashOutDto;
import cn.com.duiba.tuia.core.api.statistics.domain.InvoiceStatisticsDataReq;

import java.util.List;

/**
 * Created by huangch on 2017/12/11 14:19
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteInvoiceService {

    /**
     * 根据主键更新发票数据
     */
    Integer updateByPrimaryKeySelective(AccountFinanceInvoiceDto record);

    /**
     * 查询代理商发票的基础信息
     *
     * @param accountId 代理商账号id
     * @return 发票的基础信息
     */
    AccountFinanceInvoiceDto queryAgentInvoiceInfo(Long accountId);

    /**
     * 查询代理商可开票的现金支出记录，前6个月
     *
     * @param accountId 代理商账号id
     * @return 可开发票的现金支出记录
     */
    List<MonthCashOutDto> queryAgentCanInvoiceCashOutList(Long accountId);

    /**
     * 保存开票申请信息
     *
     * @param req 发票信息
     * @return true保存成功，false保存失败
     */
    Boolean saveApplyInvoice(AccountFinanceInvoiceDto req);

    /**
     * 查询代理商开票记录
     *
     * @return 代理商开票记录分页数据
     */
    List<AccountFinanceInvoiceDto> queryInvoiceHistory(InvoiceHistoryReq req);

    /**
     * 查询代理商开票记录
     *
     * @return 代理商开票记录分页数据
     */
    Integer countInvoiceHistory(InvoiceHistoryReq req);

    /**
     * 确认收票
     *
     * @param financeInvoiceId 财务开票记录的id，查询代理商开票记录时返回的
     * @return true 确认成功 false 确认失败
     */
    Boolean confirmReceiveInvoice(Long financeInvoiceId);

    /**
     * 计数代理商开票统计信息
     *
     * @return 数量
     */
    Integer countAgentInvoiceStatisticsData(InvoiceStatisticsDataReq req);

    /**
     * 查询代理商开票统计数据
     *
     * @return 开票统计数据
     */
    List<AgentInvoiceStatisticsDataDto> queryAgentInvoiceStatisticsData(InvoiceStatisticsDataReq req);
}
