package cn.com.duiba.tuia.core.api.enums;

/**
 * 广告导出数据文件名称枚举 date: 2017年5月24日 上午10:19:02 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AdvertStatisticsDataFileNameEnum {
    /** 广告统计数据. */
    ADVERT_STATISTICS_DATA(1, "广告统计数据"),

    /** 广告每日统计数据. */
    ADVERT_DAILY_STATISTICS_DATA(2, "广告每日统计数据"),

    /** 广告主统计数据. */
    ADVERTISER_STATISTICS_DATA(3, "广告主统计数据"),

    /** 应用统计数据. */
    APP_STATISTICS_DATA(4, "应用统计数据"),

    /** 广告定向配置数据. */
    ADVERT_ORIENT_PACKAGE_STATISTICS_DATA(5, "广告定向配置数据"),

    /** 广告定向配置数据. */
    ADVERT_ORIENT_PACKAGE_STATISTICS_HOURLY_DATA(6, "广告定向配置每小时数据"),

    /** 广告定向配置应用数据. */
    ADVERT_ORIENT_PACKAGE_STATISTICS_APP_DATA(7, "广告定向配置应用数据"),
    
    /** 广告素材数据. */
    ADVERT_MATERIAL_STATISTICS_DATA(8, "广告素材数据");

    /** 代码 */
    private int    code;
    /** 描述 */
    private String desc;

    private AdvertStatisticsDataFileNameEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AdvertStatisticsDataFileNameEnum getByCode(int code) {
        for (AdvertStatisticsDataFileNameEnum enumVal : AdvertStatisticsDataFileNameEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
