package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertStatisticsDayDto;
import cn.com.duiba.tuia.core.api.dto.advert.GroupDataDto;
import cn.com.duiba.tuia.core.api.dto.statistics.req.SelectGroupDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertiserDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertiserDataRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * Created by huangch on 2017/8/28 15:09
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertStatisticsDayService {

    /**
     * 根据广告ids和时间段查询
     *
     * @param advertIds
     * @param startDate
     * @param endDate
     * @return
     */
    DubboResult<List<AdvertStatisticsDayDto>> listAdvertStatisticsByAdvertIds(List<Long> advertIds, String startDate, String endDate);

    /**
     * 查询广告总数.<br>
     * [使用说明]
     * <ol>
     * <li>如果开始时间为2016-06-10， 结束时间为2016-06-21</li>
     * <li>广告列表为[1,2,3,4,5]</li>
     * <li>在11号有广告1,2,3有数据，12号1有数据，13号4、5有数据。则总数为6</li>
     * </ol>
     *
     * @param advertIds 广告ID列表
     * @param startDate 开始时间,格式：yyyy-mm-dd
     * @param endDate   结束时间,格式：yyyy-mm-dd
     * @return 广告组总数
     */
    DubboResult<Integer> selectAdvertAmount(List<Long> advertIds, String startDate, String endDate);

    /**
     * 查询广告组每日统计总数.<br>
     * [使用说明]
     * <ol>
     * <li>如果开始时间为2016-06-10， 结束时间为2016-06-21</li>
     * <li>如果在这个时间段内， 只在11号产生了消费数据， 则统计总数为1</li>
     * </ol>
     *
     * @param advertIds 广告ID列表
     * @param startDate 开始时间,格式：yyyy-mm-dd
     * @param endDate   结束时间,格式：yyyy-mm-dd
     * @return the int
     */
    DubboResult<Integer> selectGroupDailyAmount(List<Long> advertIds, String startDate, String endDate);

    /**
     * 按日统计广告数据.<br>
     * [使用说明]
     * <ol>
     * <li>按天统计广告在每天的数据总和，如广告列表在21号、22号等分别的总消费数据</li>
     * <li>数据：发劵量、曝光、点击、有效点击、消费、计费次数和日期</li>
     * </ol>
     *
     * @return the list< group data v o>
     */
    DubboResult<List<GroupDataDto>> selectGroupDailyDatas(SelectGroupDataReq req);

    /**
     * 查询广告数据.<br>
     * [使用说明]
     * <ol>
     * <li>如果开始时间为2016-06-10， 结束时间为2016-06-21</li>
     * <li>广告列表为[1,2,3,4,5]</li>
     * <li>在11号有广告1,2,3有数据，12号1有数据，13号4、5有数据。</li>
     * <li>返回结果为：[广告1在11号的数据， 广告2在11号的数据， 广告3在11号的数据， 广告1在12号的数据， 广告4在13号的数据， 广告5在13号的数据]</li>
     * <li>数据：发劵量、曝光、点击、有效点击、消费、计费次数、计费单价、是否结算、广告ID和日期</li>
     * </ol>
     *
     * @return 广告组数据
     */
    DubboResult<List<GroupDataDto>> selectAdvertDatas(SelectGroupDataReq req);


    /**
     * 查询广告主数据总(条)数.
     *
     * @return the statistics
     */
    DubboResult<Integer> getAdvertiserDataAmount(GetAdvertiserDataReq req);

    /**
     * 查询广告主数据.
     *
     * @return the daily data
     */
    DubboResult<List<GetAdvertiserDataRsp>> getAdvertiserData(GetAdvertiserDataReq req);

    /**
     * 查询非推啊广告的广告数据.
     *
     * @param advertId 广告ID
     * @param curDate  记录时间
     * @return the advert statistics day do
     */
    DubboResult<List<AdvertStatisticsDayDto>> selectByAdvertIdAndCurDate(Long advertId, String curDate);

    /**
     * 更新消费记录：每日消费、计费次数和 计费单价.
     *
     * @param id               the id
     * @param diffConsumeTotal 变化的消费金额
     * @param count            计费次数
     * @param price            计费单价
     * @return the int
     */
    DubboResult<Integer> updateBillingData(Long id, Long diffConsumeTotal, Integer count, Long price);

    /**
     * 把计费周期大于date的计费数据状态置为已结算.
     *
     * @param date 结算周期(格式为：yyyy-mm-dd)
     */
    DubboResult<Integer> updateSettlement(Date date);

    /**
     * 新增统计数据.
     *
     * @param record the record
     * @return the int
     */
    DubboResult<Integer> insert(AdvertStatisticsDayDto record);

    /**
     * 根据广告ID集合批量查询广告前一天统计信息.
     *
     * @param advertIds the advert ids
     * @param yesterday the yesterday
     * @return the list< advert statistics day d o>
     */
    DubboResult<List<AdvertStatisticsDayDto>> selectAdvertStatisticsByIds(List<Long> advertIds, String yesterday);

    /**
     * 批量插入，此接口是for循环里面批量插入
     *
     * @param records
     * @return
     */
    DubboResult<Integer> batchInsertStatisticsData(List<AdvertStatisticsDayDto> records);

    /**
     * 获取昨日点击均价
     * @param advertId
     * @return
     */
    Integer getYesterdayAvgClick(Long advertId);

    AdvertStatisticsDayDto getByAdvertIdAndCurDate(Long advertId, Date curDate);

}
