/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteEmployeeBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年9月7日下午1:44:09<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.BaseAccountDto;
import cn.com.duiba.tuia.core.api.dto.EmployeeDto;
import cn.com.duiba.tuia.core.api.dto.IdAndCount;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqSelectEmployees;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteEmployeeBackendService <br/>
 * Function: 协作员. <br/>
 * date: 2016年9月7日 下午1:44:09 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteEmployeeBackendService {

    /**
     * 新增协作员.
     *
     * @param employeeDto the employee dto
     * @return the dubbo result< long>
     */
    Long insert(EmployeeDto employeeDto);

    /**
     * 查询代理商下(已启用)协作员列表.
     *
     * @param agentId 代理商ID
     * @param role 角色ID
     * @return the dubbo result< boolean>
     */
    DubboResult<List<BaseAccountDto>> selectListByRole(Long agentId, Long role);

    /**
     * 协作员.
     *
     * @param agentId the agent id
     * @param employeeId the employee id
     * @return the dubbo result< long>
     */
    DubboResult<Boolean> delete(long agentId, long employeeId);

    /**
     * 暂停或启用协作员状态.
     *
     * @param agentId the agent id
     * @param employeeId the employee id
     * @param status the status
     * @return the dubbo result< long>
     */
    DubboResult<Boolean> updateEnableStatus(long agentId, long employeeId, int status);

    /**
     * 操作员和广告主是否绑定.
     *
     * @param advertiserId the advertiser id
     * @param employeeId the employee id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> isBind(long advertiserId, long employeeId);

    /**
     * 查询操作员下所有广告主基本信息列表.
     *
     * @param employeeId 操作员ID
     * @return 广告主基本信息列表
     */
    DubboResult<List<BaseAccountDto>> selectAdvertisersByEmployeeId(Long employeeId);

    /**
     * 根据广告主ID查询绑定关系.
     *
     * @param advertiserId 广告主ID
     * @return 绑定关系
     */
    DubboResult<Long> getEmployeeIdByAdvertiserId(Long advertiserId);

    /**
     * 代理商权限管理获取员工列表.
     *
     * @param req the req
     * @return the dubbo result< page dto< employee dto>>
     */
    DubboResult<PageDto<EmployeeDto>> selectEmployeesInfo(ReqSelectEmployees req);
    
    /**
     * 批量查询操作员关联的广告主个数.
     *
     * @param operatorIds the operator ids
     * @return the dubbo result< list< id and count>>
     */
    DubboResult<List<IdAndCount>> selectAdvertiserNum(List<Long> operatorIds);
    
    /**
     * 通过客户邮箱和客户名称查询客户关联的操作员ID集合.
     *
     * @param agentId the agent id
     * @param email the email
     * @param companyName the company name
     * @return the operator ids
     */
    DubboResult<List<Long>> getOperatorIds(Long agentId,String email,String companyName);
}
