/**
 * 文件名： ValidAdvertInfo.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月19日 下午2:08:23
 */
package cn.com.duiba.tuia.core.api.dto.advert;

import java.io.Serializable;

/**
 * 有效广告信息.
 *
 * @author haungch
 */
public class ValidAdvertInfoDto implements Serializable {

    private static final long serialVersionUID = -8426997137497360586L;

    /**
     * 广告ID.
     */
    private Long advertId;

    /**
     * 广告主ID.
     */
    private Long accountId;

    /**
     * 广告名称.
     */
    private String advertName;

    /**
     * 广告主名称.
     */
    private String accountName;

    /**
     * 发券量.
     */
    private Long launchCount;

    /**
     * 消费.
     */
    private Long consumeTotal;

    /**
     * 广告出价.
     */
    private Long fee;

    /**
     * 平均收益.
     */
    private Integer averageIncome;

    /**
     * 级别.
     */
    private Long level;

    /**
     * 级别更新时间ms数.
     */
    private Long levelUpdateTime;

    /**
     * @return the levelUpdateTime
     */
    public Long getLevelUpdateTime() {
        return levelUpdateTime;
    }

    /**
     * @param levelUpdateTime the levelUpdateTime to set
     */
    public void setLevelUpdateTime(Long levelUpdateTime) {
        this.levelUpdateTime = levelUpdateTime;
    }

    /**
     * Gets the level.
     *
     * @return the level
     */
    public Long getLevel() {
        return level;
    }

    /**
     * Sets the level.
     *
     * @param level the level to set
     */
    public void setLevel(Long level) {
        this.level = level;
    }

    /**
     * Gets the account id.
     *
     * @return the accountId
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * Sets the account id.
     *
     * @param accountId the accountId to set
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * Gets the advert id.
     *
     * @return the advertId
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advertId to set
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the advert name.
     *
     * @return the advertName
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * Sets the advert name.
     *
     * @param advertName the advertName to set
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * Gets the account name.
     *
     * @return the accountName
     */
    public String getAccountName() {
        return accountName;
    }

    /**
     * Sets the account name.
     *
     * @param accountName the accountName to set
     */
    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    /**
     * Gets the launch count.
     *
     * @return the launchCount
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * Sets the launch count.
     *
     * @param launchCount the launchCount to set
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * Gets the consume total.
     *
     * @return the consumeTotal
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * Sets the consume total.
     *
     * @param consumeTotal the consumeTotal to set
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * Gets the fee.
     *
     * @return the fee
     */
    public Long getFee() {
        return fee;
    }

    /**
     * Sets the fee.
     *
     * @param fee the fee to set
     */
    public void setFee(Long fee) {
        this.fee = fee;
    }

    /**
     * Gets the average income.
     *
     * @return the averageIncome
     */
    public Integer getAverageIncome() {
        return averageIncome;
    }

    /**
     * Sets the average income.
     *
     * @param averageIncome the averageIncome to set
     */
    public void setAverageIncome(Integer averageIncome) {
        this.averageIncome = averageIncome;
    }

}
