package cn.com.duiba.tuia.core.api.enums.fincance;

/**
 * Created by huangch on 2017/12/11 17:39
 * description: 发票状态枚举
 *
 * @since JDK 1.6
 */
public enum InvoiceStatusEnum {

    APPLY_INVOICE(1, "申请开票"),
    ALREADY_INVOICE(2, "已开票"),
    REFUSE_INVOICE(3, "已拒绝"),
    CONFIRM_INVOICE(4, "已确认收票");

    private Integer status;

    private String desc;

    InvoiceStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static String getInvoiceDesc(Integer status) {
        if (status == null) {
            return "";
        }
        for (InvoiceStatusEnum statusEnum : values()) {
            if (statusEnum.getStatus().equals(status)) {
                return statusEnum.getDesc();
            }
        }
        return "";
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
