package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.model.DubboResult;

@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 模糊查询标签.
     *
     * @param name 标签名称
     * @return 标签列表
     */
    @SuppressWarnings("rawtypes")
    DubboResult fuzzyQueryByTagName(String name);

    /**
     * 根据标签名，查询所有上级标签.
     *
     * @param name 标签名称
     * @return 标签列表
     */
    @SuppressWarnings("rawtypes")
    DubboResult queryParentTags(String name);

}
