package cn.com.duiba.tuia.core.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.data.ReqAdvertOrientPackageDataDto;
import cn.com.duiba.tuia.core.api.dto.rsp.data.RspAdvertOrientPackageStatisticsByPage;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 广告定向配置每日预算、消费、曝光等数据统计接口
 * date: 2017年5月22日 上午10:03:40 <br/>
 *
 * @author chencheng
 * @version
 */
@AdvancedFeignClient
public interface RemoteAdvertOrientPackageStatisticsDayService {

    /**
     * 分页查询广告定向配置每日预算、消费、曝光等数据
     *
     * @author chencheng
     * @param req
     * @return
     * @throws TuiaCoreException
     */
    DubboResult<RspAdvertOrientPackageStatisticsByPage> selectOrientPackageStatisticsDayByPage(ReqAdvertOrientPackageDataDto req);
    
    /**
     * 修改广告定向配置每日预算表当日的定向配置预算数据
     *
     * @author chencheng
     * @param budget 预算
     * @param orientPackageId 配置包id
     * @return
     * @throws TuiaCoreException
     */
    DubboResult<Integer> updateAdvertOrientPackageBudgetConsumeDay(Long budget, Long orientPackageId);

}
