package cn.com.duiba.tuia.core.api.remoteservice.mediaremind;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.mail.MailDto;
import cn.com.duiba.tuia.core.api.dto.mediaremind.MediaCostRemindDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/10/12 10:17
 * description:统一的邮件发送服务
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteMediaCostRemindService {

    void add(MediaCostRemindDto mediaCostRemindDto);

    void update(MediaCostRemindDto mediaCostRemindDto);

    /**
     * 不存在就新增，存在就更新
     * @param mediaCostRemindDto
     */
    void upsert(MediaCostRemindDto mediaCostRemindDto);

    /**
     * 获取配置
     * @param advertIds
     * @return
     */
    List<MediaCostRemindDto> getByAdvertIds(List<Long> advertIds);
}
