/**
 * 文件名： MemcachedKeyTool.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月8日 上午11:17:51
 */
package cn.com.duiba.tuia.core.api.utils;

import cn.com.duiba.tuia.core.api.constant.CacheKey;

/**
 * 缓存标识.
 *
 * @author: leiliang
 * @version:
 */
public class CachedKeyUtils {

    /** The prefix. */
    private static String prefix;

    /**
     * The Constructor.
     */
    private CachedKeyUtils() {
    }

    /**
     * Gets the prefix.
     *
     * @return the prefix
     */
    public static String getPrefix() {
        return prefix;
    }

    /**
     * Sets the prefix.
     *
     * @param prefix the prefix
     */
    public static void setPrefix(String prefix) {
        CachedKeyUtils.prefix = prefix;
    }

    /**
     * 获取广告缓存标识.
     *
     * @param advertId 广告ID
     * @return the advert key
     */
    public static String getAdvertKey(Long advertId) {
        return getPrefix() + CacheKey.MS_ADVERT_KEY + advertId;
    }

    /**
     * 获取协作员登录缓存标识.
     *
     * @param employeeId 协作员ID
     * @param times the times
     * @return 协作员登录缓存标识
     */
    public static String getEmployeeLoginKey(Long employeeId, long times) {
        return getPrefix() + CacheKey.MS_EMPLOYEE_LOGIN_KEY + times + "-" + employeeId;
    }

    /**
     * 获取协作员绑定广告主缓存标识.
     *
     * @param advertiserId 广告主id
     * @param employeeName 协作员名称
     * @return 协作员绑定广告主缓存标识
     */
    public static String getEmployeeBindAdvertiserKey(Long advertiserId, String employeeName) {
        return getPrefix() + CacheKey.MS_EMPLOYEE_BIND_ADVERTISER_KEY + advertiserId + "-" + employeeName;
    }

    /**
     * 获取角色授权访问的后端接口url缓存标识.
     *
     * @param roleId 角色Id
     * @return 角色授权访问的后端接口url缓存标识
     */
    public static String getRoleAuthorAccessUrlsKey(Long roleId) {
        return getPrefix() + CacheKey.MS_ROLE_AUTHOR_ACCESS_URLS_KEY + roleId;
    }

    /**
     * 获取角色授权访问的前端菜单缓存标识.
     *
     * @param roleId 角色Id
     * @return 角色授权访问的前端菜单缓存标识
     */
    public static String getRoleAuthorAccessMenusKey(Long roleId) {
        return getPrefix() + CacheKey.MS_ROLE_AUTHOR_ACCESS_MENUS_KEY + roleId;
    }

    /**
     * 得到所有菜单的缓存标识.
     *
     * @return 所有菜单的缓存标识
     */
    public static String getAllMenusKey() {
        return getPrefix() + CacheKey.MS_ALL_MENUS_KEY;
    }

    /**
     * 获取所有标签缓存标识.
     *
     * @return the all tag key
     */
    public static String getAllTagKey() {
        return getPrefix() + CacheKey.TC_ALL_TAG_KEY;
    }

    /**
     * 获取所有标签缓存标识.
     *
     * @return the all tag key
     */
    public static String getAllItemIdsKey(String curDate) {
        return getPrefix() + '-' + curDate + CacheKey.ALL_ITEM_ID_KEY;
    }

    /**
     * 根据Itemid查询关联的广告ID的缓存标识.
     *
     * @param itemId the item id
     * @return the advert id by itme id
     */
    public static String getAdvertIdByItmeId(String curDate, long itemId) {
        return getPrefix() + '-' + curDate + CacheKey.GET_ADVERTID_BY_ITEMID_KEY + itemId;
    }

    /**
     * 根据Itemid查询关联的广告ID的缓存标识.
     *
     * @param materialId the material id
     * @param appId the app id
     * @return the advert id by itme id
     */
    public static String getAddMaterialAppRelation(long materialId, long appId) {
        return getPrefix() + CacheKey.ADD_MATERIAL_APP_RELATION_KEY + materialId + "-" + appId;
    }

}
