package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.PrivilegeAppDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryPrivilegeApp;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by 李志辉 on 2017-05-26 13:44.
 * 管理端特权媒体相关api
 */
@AdvancedFeignClient
public interface RemotePrivilegeAppService {

    /**
     * 分页查询特权媒体(app) 列表
     *
     * @param query 查询条件
     * @return 列表
     */
    DubboResult<PageDto<PrivilegeAppDto>> pageQuery(ReqPageQueryPrivilegeApp query);


    /**
     * 添加特权媒体
     *
     * @param appId 媒体(应用) id
     * @return 是否添加成功
     */
    DubboResult<Boolean> add(Long appId);

    /**
     * 移除特权媒体
     *
     * @param appId 媒体(应用) id
     * @return 是否移除成功
     */
    DubboResult<Boolean> remove(Long appId);

    /**
     * 关闭全部特权媒体
     *
     * @return 是否关闭成功
     */
    DubboResult<Boolean> turnOffAll();

    /**
     * 开启全部特权媒体
     *
     * @return 是否开启成功
     */
    DubboResult<Boolean> turnOnAll();

    /**
     * 根据appId 获取简单信息
     * @param appId
     * @return
     */
    DubboResult<PrivilegeAppDto> getById(Long appId);
}
