/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class UrlBase64 {
    private static Logger logger = LoggerFactory.getLogger(UrlBase64.class);

    public static String urlBase64Encode(String data) {
        try {
            return UrlBase64.safeUrlBase64Encode(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("url base64 encode error", (Throwable)e);
            return "";
        }
    }

    public static String urlBase64Decode(String data) {
        if (StringUtils.isBlank((String)data)) {
            return "";
        }
        try {
            return new String(UrlBase64.safeUrlBase64Decode(data), "UTF-8");
        }
        catch (IOException e) {
            logger.error("url base64 decode error", (Throwable)e);
            return "";
        }
    }

    public static String safeUrlBase64Encode(byte[] data) {
        String encodeBase64 = new BASE64Encoder().encode(data);
        String safeBase64Str = encodeBase64.replace('+', '-');
        safeBase64Str = safeBase64Str.replace('/', '_');
        safeBase64Str = safeBase64Str.replaceAll("=", "");
        return safeBase64Str;
    }

    public static byte[] safeUrlBase64Decode(String safeBase64Str) throws IOException {
        String base64Str = safeBase64Str.replace('-', '+');
        int mod4 = (base64Str = base64Str.replace('_', '/')).length() % 4;
        if (mod4 > 0) {
            base64Str = base64Str + "====".substring(mod4);
        }
        return new BASE64Decoder().decodeBuffer(base64Str);
    }
}

