/**
 * Project Name:tuia-domain<br>
 * File Name:CouponCodeSumInfo.java<br>
 * Package Name:cn.com.duiba.tuia.domain.model<br>
 * Date:2016年7月7日下午2:44:51<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

/**
 * ClassName: CouponCodeSumInfo <br/>
 * Function: 优惠码基本信息. <br/>
 * date: 2016年7月7日 下午2:44:51 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class CouponBatchSummDto implements Serializable {

    private static final long serialVersionUID = 1;

    /** 优惠码ID. */
    private Long              id;

    /** 优惠码内容. */
    private String            codeContent;

    /** 优惠码密码. */
    private String            codePd;

    /** 初始库存. 默认-1代表无线库存 */
    private Long              inventory = -1L;

    /** 当前库存. */
    private Long              curInventory;

    /** 上传记录ID. */
    private Long              uploadRecordId;

    public Long getCurInventory() {
        return curInventory;
    }

    public void setCurInventory(Long curInventory) {
        this.curInventory = curInventory;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCodeContent() {
        return codeContent;
    }

    public void setCodeContent(String codeContent) {
        this.codeContent = codeContent;
    }

    public String getCodePd() {
        return codePd;
    }

    public void setCodePd(String codePd) {
        this.codePd = codePd;
    }

    public Long getInventory() {
        return inventory;
    }

    public void setInventory(Long inventory) {
        this.inventory = inventory;
    }

    public Long getUploadRecordId() {
        return uploadRecordId;
    }

    public void setUploadRecordId(Long uploadRecordId) {
        this.uploadRecordId = uploadRecordId;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CouponBatchSummDto [id=");
        builder.append(id);
        builder.append(", codeContent=");
        builder.append(codeContent);
        builder.append(", codePd=");
        builder.append(codePd);
        builder.append(", endValid=");
        builder.append(", startValid=");
        builder.append(", inventory=");
        builder.append(inventory);
        builder.append(", curInventory=");
        builder.append(curInventory);
        builder.append(", uploadRecordId=");
        builder.append(uploadRecordId);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
