/**
 * Project Name:manager-domain File Name:GetDailyDataReq.java Package Name:cn.com.duiba.tuia.manager.req
 * Date:2016年5月24日下午4:12:50 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import java.util.List;

/**
 * ClassName:GetDailyDataReq <br/>
 * Function: 查询广告每日统计数据请求参数. <br/>
 * Date: 2016年5月24日 下午4:12:50 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel("查询广告每日统计数据请求参数")
public class GetDailyDataReq extends ByDateQueryReq {

    private static final long serialVersionUID = -1111610555854034150L;

    /** 广告ID. */
    @NotNull(message = "广告ID不为空")
    @ApiModelProperty(value = "广告ID", required = true)
    private Long   advertId;

    @ApiModelProperty("广告名称")
    private String advertName;

    @ApiModelProperty("广告主ID集合")
    private List<Long> advertIds;

    /**
     * advertName.
     *
     * @return the advertName
     * @since JDK 1.7
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * advertName.
     *
     * @param advertName the advertName to set
     * @since JDK 1.7
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.7
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.7
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    /**
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
