/**
 * Project Name:tuia-advert-center-api File Name:ReqLoadingPageAppEffectDto.java Package
 * Name:cn.com.duiba.tuia.core.api.dto.req.data Date:2017年8月26日下午3:23:31 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.data;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDateReq;

/**
 * ClassName:ReqLoadingPageAppEffectDto <br/>
 * Function: 落地页APP维度数据查询. <br/>
 * Date: 2017年8月26日 下午3:23:31 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
public class ReqLoadingPageAppEffectDto extends BaseQueryDateReq {

    private static final long serialVersionUID = -562725763791244195L;

    /** 广告ID. */
    private Long       advertId;

    /** 媒体ID集合. */
    private List<Long> appIds;

    /** 0 or null ：汇总，1：分日 */
    private Integer    exportType;

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * appIds.
     *
     * @return the appIds
     * @since JDK 1.8
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * appIds.
     *
     * @param appIds the appIds to set
     * @since JDK 1.8
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * exportType.
     *
     * @return the exportType
     * @since JDK 1.8
     */
    public Integer getExportType() {
        return exportType;
    }

    /**
     * exportType.
     *
     * @param exportType the exportType to set
     * @since JDK 1.8
     */
    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
