package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.app.AppTagDto;
import cn.com.duiba.tuia.core.api.dto.app.AppTagLibraryDto;

import java.util.List;
import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年12月14日 10:00
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteAppTagService {

    void addDuibaAppTag(AppTagDto appTagDto);

    Map<Long, AppTagDto> getDuibaTagMapByAppIds(List<Long> appIds);

    /**
     * 获取媒体的标签信息
     *
     * @param appIds
     * @return
     */
    Map<Long, AppTagDto> getAppTagByAppIds(List<Long> appIds);

    /**
     * 获取媒体行业标签列表
     *
     * @return
     */
    List<AppTagLibraryDto> getAppIndustryTags();


    /**
     * 通过标签ID查询媒体
     *
     * @param tagId
     * @return
     */
    List<Long> getAppIdsByTagId(Long tagId, Integer blockType);
}
