package cn.com.duiba.tuia.core.api.dto.jfsite;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * [JF建站]站点域名
 * @author lijicong
 * @since 2020-07-24
 */
@Getter
@Setter
public class JfSiteDomainFormDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("域名")
    private String domainName;

    @ApiModelProperty("域名List")
    private List<String> domainNameList;

    @ApiModelProperty("域名类型")
    private Integer domainType;

    @ApiModelProperty("域名状态 -1:初始化 0:失效 1:正常")
    private Integer domainStatus;

    @ApiModelProperty("失效时间")
    private Date invalidTime;

    @ApiModelProperty("账户表ID")
    private Long accountId;

    @ApiModelProperty("创建人ID")
    private Long creatorId;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("修改人")
    private String modifier;

}