package cn.com.duiba.tuia.core.api.enums;

import java.util.Objects;

/**
 * Created by zhangshun on 2019/7/31.
 */
public enum AdvertStatisticsReportSubtypeEnum {

    INSTALL(1, "安装APP"),
    START(2, "启动APP"),
    REGISTER(3, "注册账号"),
    ACTIVATION(4, "激活账号"),
    LOGIN(5, "登录账号"),
    PAY(6, "用户付费"),
    ING(7, "用户进件"),
    COMPLETE(8, "用户完件"),
    SIGN(9, "用户签收"),
    REJECT(10, "留存")

    ;

    private String desc;

    private Integer code;

    AdvertStatisticsReportSubtypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public static String getDescByCode(Integer code) {
        for (AdvertStatisticsReportSubtypeEnum item : AdvertStatisticsReportSubtypeEnum.values()) {
            if (Objects.equals(item.getCode(), code)) {
                return item.getDesc();
            }
        }
        return "未知";
    }
}
