package cn.com.duiba.tuia.core.api.enums;

/**
 * @Author:zhangmeng
 * @Date:2018-05-24
 * @Function:全局流量配置配置条件
 */
public enum GlobalConditionEnum {

    ADVERT_TAG(1,"advertTags"),
    PROMOTE_URL_TAG(2,"promoteUrlTags"),
    SOURCE(3,"source");

    private String name;
    private Integer code;

    private GlobalConditionEnum(Integer code,String name){
        this.code=code;
        this.name=name;
    }

    public static GlobalConditionEnum getCodeByName(String name){
        for(GlobalConditionEnum item:GlobalConditionEnum.values()){
            if(item.getName().equals(name)){
                 return item;
            }
        }
        return null;
    }

    public static GlobalConditionEnum getNameByCode(Integer code){
        for(GlobalConditionEnum item:GlobalConditionEnum.values()){
            if(item.getCode().equals(code)){
                return item;
            }
        }
        return null;
    }


    public String getName() {
        return name;
    }

    public Integer getCode() {
        return code;
    }
}
