package cn.com.duiba.tuia.core.api.enums.adx;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * description:dsp平台送审 素材长宽校验
 *
 * @since JDK 1.8
 */
public enum DspCheckImageEnum {

    //1-互动广告
    INTERACTIVE_ADVERT(1, (w, h) -> {
        boolean flag = false;
        //640 * 300
        if (w == 640 && h == 300) {
            flag = true;
        }
        return flag;
    }),
    //2-展示广告
    //SHOW_ADVERT(2, ""),
    //3-激励广告
    //ENCOURAGE_ADVERT(3, "送审成功")
    ;


    //dsp 送审 状态
    private Integer type;
    //送审 状态 说明
    private CheckParamInterface param;

    public Integer getType() {
        return type;
    }

    public CheckParamInterface getParam() {
        return param;
    }

    DspCheckImageEnum(Integer type, CheckParamInterface param) {
        this.type = type;
        this.param = param;
    }

    @FunctionalInterface
    interface CheckParamInterface {
        Boolean checkParam(int width, int height);
    }

    /**
     * 验证宽高
     *
     * @param width
     * @param height
     * @return
     */
    public Boolean check(int width, int height) {
        return param.checkParam(width, height);
    }

    private static Map<Integer, DspCheckImageEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(DspCheckImageEnum.values())
                .collect(Collectors.toMap(DspCheckImageEnum::getType, Function.identity()));
    }

    public static DspCheckImageEnum getByCode(Integer type) {
        return ENUM_MAP.get(type);
    }


}
