/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertMaterialService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年12月23日下午3:34:25<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialAdxDirectDto;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialCheckStatusDto;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialDto;

import java.util.List;

/**
 * ADX直投素材接口
 *
 * Created by zhangshun on 20200204.
 *
 */
@AdvancedFeignClient
public interface RemoteAdvertAdxDirectMaterialService {

    /**
     * 内部审核通过, 调用外部审核后, 更新外部审核ID
     * @param dto
     * @return
     */
    Boolean updateExternalAuditId(Long adxDirectId, Long directlyAuditId, Integer checkStatus, String reason);

    /**
     * 更新素材审核结果  流量线调用
     * @param directlyAuditId 审核ID
     * @param checkStatus 状态,审核状态 0-审核通过 2-提交审核 3-审核拒绝
     * @param reason 审核拒绝原因
     * @return
     */
    Boolean updateAuditStatus(Long directlyAuditId, Integer checkStatus, String reason);

    /**
     * 插入ADX直投素材
     *
     * @param dto
     * @return
     */
    Boolean insert(AdvertMaterialDto materialDto, AdvertMaterialAdxDirectDto adxDirectDto);

    /**
     * 编辑ADX直投素材
     *
     * @param dto
     * @return
     */
    Boolean update(Integer checkStatus, AdvertMaterialAdxDirectDto dto);

    /**
     * 根据ID查询adx直投素材
     *
     * @param id
     * @return
     */
    AdvertMaterialAdxDirectDto findById(Long id);

    /**
     * 根据ID查询adx直投素材
     *
     * @param list
     * @return
     */
    List<AdvertMaterialAdxDirectDto> findByMaterialIdList(List<Long> list);

    /**
     * 根据广告ID查询adx直投素材
     *
     * @param advertId
     * @return
     */
    List<AdvertMaterialAdxDirectDto> findByAdxDirectMaterial(Long advertId);

    /**
     * 根据外部审核ID查询素材的状态
     * @param auditIdList
     * @return
     */
    List<AdvertMaterialCheckStatusDto> findByAuditIdList(List<Long> auditIdList);

}
