package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.ConfigTargetRecordDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.ConfigTargetRecordReq;

import java.util.List;

/**
 * 广告配置定向记录
 * Created by lijan on 2021/3/2 11:56
 * description:
 *
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteConfigTargetRecordService {

    /**
     * 保存记录.
     *
     * @param dto
     * @return int
     */
    Integer save(ConfigTargetRecordDto dto);

    /**
     * 根据条件获取广告配置定向记录列表
     *
     * @param req
     * @return
     */
    List<ConfigTargetRecordDto> getRecordByParam(ConfigTargetRecordReq req);
}
