package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PutLinkageConfigDto;

import java.util.List;

@AdvancedFeignClient
public interface RemotePutLinkageConfigService {

    /**
     * 保存
     *
     * @param dto
     * @return
     */
    Integer save(PutLinkageConfigDto dto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 更新
     *
     * @param dto
     * @return
     */
    Integer updateById(PutLinkageConfigDto dto);

    /**
     * 根据 新行业和优化目标查询 联动数据
     *
     * @param newTrade
     * @param subType
     * @return
     */
    List<PutLinkageConfigDto> getByTradeSub(String newTrade, Integer subType);

    /**
     * 获取配置数据列表
     * @return
     */
    List<PutLinkageConfigDto> listByParam();

    /**
     * 根据ID查询配置数据
     * @param id
     * @return
     */
    PutLinkageConfigDto getById(Long id);

}
