/**
 * Project Name:tuia-core-api<br>
 * File Name:RspGetStatisticsByPage.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp<br>
 * Date:2016年9月9日下午4:35:22<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;
import java.util.List;

import cn.com.duiba.tuia.core.api.dto.AccountStatisticsDayDto;

/**
 * ClassName: RspGetStatisticsByPage <br/>
 * date: 2016年9月9日 下午4:35:22 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RspGetAccountStasByPage implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long             serialVersionUID = 8455230363864762804L;

    /** 协作员列表. */
    private List<AccountStatisticsDayDto> accounts;

    /** 查询总数. */
    private int                           totalamount;

    public RspGetAccountStasByPage() {
        super();
    }

    /**
     * Creates a new instance of RspGetAccountStasByPage.
     *
     * @param accounts
     * @param totalamount
     */

    public RspGetAccountStasByPage(List<AccountStatisticsDayDto> accounts, int totalamount) {
        super();
        this.accounts = accounts;
        this.totalamount = totalamount;
    }

    /**
     * accounts.
     *
     * @return the accounts
     * @since JDK 1.6
     */
    public List<AccountStatisticsDayDto> getAccounts() {
        return accounts;
    }

    /**
     * accounts.
     *
     * @param accounts the accounts to set
     * @since JDK 1.6
     */
    public void setAccounts(List<AccountStatisticsDayDto> accounts) {
        this.accounts = accounts;
    }

    /**
     * totalamount.
     *
     * @return the totalamount
     * @since JDK 1.6
     */
    public int getTotalamount() {
        return totalamount;
    }

    /**
     * totalamount.
     *
     * @param totalamount the totalamount to set
     * @since JDK 1.6
     */
    public void setTotalamount(int totalamount) {
        this.totalamount = totalamount;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RspGetAccountStasByPage [accounts=");
        builder.append(accounts);
        builder.append(", totalamount=");
        builder.append(totalamount);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
