/**
 * Project Name:tuia-advert-center-api
 * File Name:AdvertConsumerCorrectionDto.java
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp.advert
 * Date:2017年8月25日下午2:32:13
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.dto.rsp.advert;

import java.math.BigDecimal;
import java.util.Date;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName:AdvertConsumerCorrectionDto <br/>
 * Function: 消费修正记录. <br/>
 * Date:     2017年8月25日 下午2:32:13 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public class AdvertConsumerCorrectionDto extends BaseDto{
    
    private static final long serialVersionUID = -5821068396819098569L;

    /** 广告ID */
    private Long advertId;

    /** 修正之后的金额 */
    private BigDecimal correctionTotal;

    /** 消费的日期 */
    private Date curDate;

    /** 修正之前的消耗：分 */
    private Long consumeTotal;

    /** 账户余额 */
    private Long financeBalance;

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public BigDecimal getCorrectionTotal() {
        return correctionTotal;
    }

    public void setCorrectionTotal(BigDecimal correctionTotal) {
        this.correctionTotal = correctionTotal;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public Long getFinanceBalance() {
        return financeBalance;
    }

    public void setFinanceBalance(Long financeBalance) {
        this.financeBalance = financeBalance;
    }
}

