package cn.com.duiba.tuia.core.api.remoteservice.agentPlatfromMessages;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.agentPlatfromMessages.AgentPaltfromMessageDto;
import cn.com.duiba.tuia.core.api.dto.agentPlatfromMessages.MessageCountInfoDto;

import java.util.List;

@AdvancedFeignClient
public interface AgentPaltfromMessageRemoteService {



    /**
     * 插入一条消息
     * @param dto
     * @return
     */
    public boolean addMessage(AgentPaltfromMessageDto dto);


    /**
     * 批量插入消息
     * @param dtos
     * @return
     */
    public boolean addMessages(List<AgentPaltfromMessageDto> dtos);
    /**
     * 获取单条消息详情
     * @param messageId
     * @return
     */
    public AgentPaltfromMessageDto getMessage(Long messageId);

    /**
     * 根据账号ids获取所有消息
     * @param accountIds
     * @return
     */
    public List<AgentPaltfromMessageDto> getMessages(List<Long> accountIds);

    /**
     * 获取消息提醒数量
     * @param accountIds
     * @return
     */
    public MessageCountInfoDto getMessageCount(List<Long> accountIds);


    /**
     * 标记消息已读
     * @param messageId
     * @return
     */
    public boolean markMessageIsRead(Long messageId);

}
