/**
 * 文件名： FinanceRecordInfo.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月14日 下午4:25:16
 */
package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;

/**
 * 财务记录信息 <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月14日 下午4:25:16
 * @version:
 */
public class FinanceRecordDto implements Serializable {

    private static final long serialVersionUID = 3041091596511263691L;

    /**
     * 账号id
     */
    private Long              accountId;

    /**
     * 当前日期,年-月-日
     */
    private String            curDate;

    /**
     * 存入
     */
    private Long              balanceIn;

    /**
     * 支出
     */
    private Long              balanceOut;

    /**
     * 类型,记录方式:AB,A位1存入,2支出;10-充值;11-退款等;20-广告扣费
     */
    private Integer           type;
    /**
     * 备注
     */
    private String            remark;

    /**
     * 广告主公司
     */
    private String            companyName;

    /**
     * @return the accountId
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * @param accountId the accountId to set
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * @return the curDate
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * @param curDate the curDate to set
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * @return the balanceIn
     */
    public Long getBalanceIn() {
        return balanceIn;
    }

    /**
     * @param balanceIn the balanceIn to set
     */
    public void setBalanceIn(Long balanceIn) {
        this.balanceIn = balanceIn;
    }

    /**
     * @return the balancOut
     */
    public Long getBalanceOut() {
        return balanceOut;
    }

    /**
     * @param balancOut the balancOut to set
     */
    public void setBalanceOut(Long balanceOut) {
        this.balanceOut = balanceOut;
    }

    /**
     * @return the type
     */
    public Integer getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * @return the remark
     */
    public String getRemark() {
        return remark;
    }

    /**
     * @param remark the remark to set
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FinanceRecordDto [accountId=");
        builder.append(accountId);
        builder.append(", curDate=");
        builder.append(curDate);
        builder.append(", balanceIn=");
        builder.append(balanceIn);
        builder.append(", balanceOut=");
        builder.append(balanceOut);
        builder.append(", type=");
        builder.append(type);
        builder.append(", remark=");
        builder.append(remark);
        builder.append(", companyName=");
        builder.append(companyName);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
