package cn.com.duiba.tuia.core.api.dto.jfsite;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * [JF建站]账户表
 * @author lijicong
 * @since 2020-07-24
 */
@Getter
@Setter
public class JfAccountDTO extends BaseDto {

    @ApiModelProperty("账户表ID")
    private Long accountId;

    @ApiModelProperty("账号状态 0:冻结 1:正常")
    private Integer accountStatus;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "密码")
    private String passwd;

    @ApiModelProperty(value = "账户类型")
    private Integer userType;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("代理商公司名称")
    private String agentCompanyName;

    @ApiModelProperty(value = "一级代理商名称")
    private Integer oneLevelAgentName;

    @ApiModelProperty("代理商等级 0-一级 1-二级 2-三级 3-四级")
    private Integer accountLevel;

    @ApiModelProperty(value = "上级代理商层级连接，点分隔")
    private String accountLevelNum;

}