package cn.com.duiba.tuia.core.api.enums.compensate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 返货赔付使用状态枚举
 *
 * @author zhangbaiqiang
 * @date 2021/4/27
 */
@Getter
@AllArgsConstructor
public enum CashBackStateEnum {

    DISABLE(0, "不可用"),
    ENABLE(1, "可用");

    private final Integer state;
    private final String  desc;

    public static String getDesc(Integer state) {
        return Objects.equals(state, ENABLE.state) ? ENABLE.desc : DISABLE.desc;
    }
}
