package cn.com.duiba.tuia.core.api.enums.compensate;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 新赔付列表的广告计划是否为新计划枚举
 *
 * @author zhangbaiqiang
 * @date 2021/1/6
 */
@Getter
@AllArgsConstructor
public enum IsNewAdvertEnum {

    NO(0, "否"),
    YES(1, "是");

    private final Integer type;
    private final String  desc;

    public static String getDesc(Integer isNew) {
        return Objects.equals(isNew, YES.type) ? YES.desc : NO.desc;
    }

    public static boolean isNew(Integer isNew) {
        return Objects.equals(isNew, YES.type);
    }
}
