package cn.com.duiba.tuia.core.api.remoteservice.account;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.account.query.AccountBalanceRecordQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.query.AccountFinanceQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.query.AdvertiserConsumeQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.query.WebDataQueryDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AccountBalanceRecordQueryResultDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.AdvertiserConsumeQueryResultDto;
import cn.com.duiba.tuia.core.api.dto.account.rsp.DataSetQueryResultDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.AccountFinanceStatisticsDayDto;
import cn.com.duiba.tuia.core.api.dto.finance.ReconciliationDataResponse;
import cn.com.duiba.tuia.core.api.dto.move.MoveFixData;

import java.util.List;
import java.util.concurrent.ExecutionException;

@AdvancedFeignClient
public interface RemoteAccountDataService {

    /**
     * 广告主消费记录
     * @param advertiserConsumeQueryDto 查询请求
     * @return
     * @throws ExecutionException
     */
    AdvertiserConsumeQueryResultDto getAdvertiserConsumeData(AdvertiserConsumeQueryDto advertiserConsumeQueryDto) throws ExecutionException;

    /**
     * 分日查询余额记录
     * @param accountBalanceRecordQueryDto
     * @return
     * @throws ExecutionException
     */
    AccountBalanceRecordQueryResultDto getAccountBalanceRecordData(AccountBalanceRecordQueryDto accountBalanceRecordQueryDto) throws ExecutionException;

    /**
     * 导出账户余额记录数据
     * @param accountBalanceRecordQueryDto
     * @return
     * @throws ExecutionException
     */
    List<AccountBalanceRecordQueryResultDto.AccountBalanceRecordDto> exportAccountBalanceRecordData(AccountBalanceRecordQueryDto accountBalanceRecordQueryDto) throws ExecutionException;

    /**
     * 财务对账
     * @param accountFinanceQueryDto
     * @return
     * @throws ExecutionException
     */
    ReconciliationDataResponse getAccountFinanceRecord(AccountFinanceQueryDto accountFinanceQueryDto) throws ExecutionException;

    /**
     * 查询一代代理商的总览(代理商平台)
     * @param webDataQueryDto
     * @return
     * @throws ExecutionException
     */
    DataSetQueryResultDto.AgentSnapshot queryAgentSnapshot(WebDataQueryDto webDataQueryDto) throws ExecutionException;

    DataSetQueryResultDto.AdvertiserSnapshot queryAdvertiserSnapshot(WebDataQueryDto webDataQueryDto) throws ExecutionException;

    DataSetQueryResultDto.SpecialAdvertiserSnapshot querySpecialAdvertiserSnapshot(WebDataQueryDto webDataQueryDto) throws ExecutionException;

    /**
     * 查询代理商平台财务记录每一条的明细
     * @param webDataQueryDto
     * @return
     * @throws ExecutionException
     */
    List<AccountFinanceStatisticsDayDto> webDataQuery(WebDataQueryDto webDataQueryDto) throws ExecutionException;

    MoveFixData getMoveNeedFixData();
}
