package cn.com.duiba.tuia.core.api.remoteservice.jfsite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 广告计划加粉配置
 * @author lijicong
 * @since 2020-08-11
 */
@AdvancedFeignClient
public interface RemoteJfAdvertConfig {

    /**
     * 设置白名单广告ids
     * @param advertIds
     * @return
     */
    boolean setAdvertIds(List<Long> advertIds);

    /**
     * 获取白名单广告ids
     * @return
     */
    List<Long> getAdvertIds();

    /**
     * 判断广告id在不在白名单里
     * @param advertId
     * @return
     */
    boolean isInAdvertWhitelist(Long advertId);

}
