package cn.com.duiba.tuia.core.api.remoteservice.jfsite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfTagDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfTagFormDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfTagQueryDTO;

import java.util.List;

/**
 * [JF建站]标签 RemoteService
 * @author lijicong
 * @since 2020-07-24
 */
@AdvancedFeignClient
public interface RemoteJfTagService {

    /**
     * 根据ID查询
     * @param id
     * @return
     */
    JfTagDTO queryById(Long id);

    /**
     * 多条件查询
     * @param queryDTO
     * @return
     */
    List<JfTagDTO> queryList(JfTagQueryDTO queryDTO);

    /**
     * 多条件查询数量
     * @param queryDTO
     * @return
     */
    long queryCount(JfTagQueryDTO queryDTO);

    /**
     * 保存
     * @param formDTO
     * @return
     */
    boolean save(JfTagFormDTO formDTO);
}