package cn.com.duiba.tuia.core.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by huangch on 2018/5/17 16:24
 * description:
 *
 * @since JDK 1.6
 */
public enum SlotCheatGradeEnum {
    grade_zero(0, "正常"),
    grade_one(1, "正常"),
    grade_two(2, "正常"),
    grade_three(3, "中危"),
    grade_four(4, "中危"),
    grade_five(5, "高危"),
    grade_six(6, "高危");

    //诊断等级
    private Integer grade;

    //诊断结果
    private String result;

    private static Map<Integer, String> gradeResultMap;

    static {
        gradeResultMap = Maps.newHashMap();
        for (SlotCheatGradeEnum gradeEnum : values()) {
            gradeResultMap.put(gradeEnum.getGrade(), gradeEnum.getResult());
        }
    }

    SlotCheatGradeEnum(Integer grade, String result) {
        this.grade = grade;
        this.result = result;
    }

    public static String getCheatGradeResult(Integer grade) {
        if (grade == null) {
            return "正常";
        }
        return gradeResultMap.get(grade);
    }

    public Integer getGrade() {
        return grade;
    }

    public String getResult() {
        return result;
    }
}
