package cn.com.duiba.tuia.core.api.enums.fincance;

/**
 * Created by lizhihui on 2017-10-17 15:10.
 */
public enum RechargeApplicationType {
                                     ONLINE(1, "线上充值"),

                                     OFFLINE(2, "线下转账"),

                                     DEDUCT(3, "退款扣除"),

                                     SYSTEM(4, "消耗调整"),

                                     BACK(5, "季度返货"),

                                     MOVE(6, "账户迁移"),
                                     /* 有东西就往6和10之间加 */

                                     FIX(7, "修偏"),

                                     DEDUCT_CASH_BACK(8, "季返扣除"),

                                     CREDIT(9, "授信"),

                                     OTHER(10, "其他"),

                                     EARNEST_MONEY_RECHARGE(11, "保证金存入"),

                                     EARNEST_MONEY_DEDUCT(12, "保证金扣费"),

                                     EARNEST_MONEY_REFUND(13, "保证金退款"),

                                     EARNEST_MONEY_RECHARGE_BIZ(14, "业务保证金存入"),

    ;

    private Integer type;
    private String  desc;

    RechargeApplicationType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDesc(Integer type) {
        for (RechargeApplicationType rechargeApplicationType : RechargeApplicationType.values()) {
            if (type.equals(rechargeApplicationType.getType())) {
                return rechargeApplicationType.getDesc();
            }
        }
        return null;
    }

    public static RechargeApplicationType get(Integer type) {
        for (RechargeApplicationType rechargeApplicationType : RechargeApplicationType.values()) {
            if (type.equals(rechargeApplicationType.getType())) {
                return rechargeApplicationType;
            }
        }
        throw new RechargeApplicationTypeNotExistException("type is not exist");
    }

    private static class RechargeApplicationTypeNotExistException extends RuntimeException {

        RechargeApplicationTypeNotExistException(String message) {
            super(message);
        }
    }
}
