package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.LandMappingDto;

import java.util.List;

/**
 * @Author:zhangmeng
 * @Date:2018-05-25
 * @Function:用于获取广告主平台落地页相关数据
 */
@AdvancedFeignClient
public interface RemoteLandPageService {
    /**
     * 新增一条落地页id，和加密id映射数据
     */
    Integer insertLandMappingItem(LandMappingDto landMappingDto);

    /**
     * 获取映射表中的数据通过落地页id
     */
    List<LandMappingDto>getLandMappingItems(List<Long> ids);

    /**
     * 获取映射表中的数据通过落地页映射id
     */
    LandMappingDto getLandMappingItem(String anonymousId);

    /**
     * 获取真实落地页地址
     */
    String getRealPromoteUrl(String promoteURL);

    /**
     * 获取展示页面商的落地页地址
     */
    String getAnonymousUrl(String promoteURL);

    /**
     * 根据广告主id查询 关联的落地页 Ids
     *
     */
    List<Long> selectLandIdsByAdvertiserId(Long advertiserId);

}
