package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertRefuseCategoryDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertRefuseTemplateDto;
import cn.com.duiba.tuia.core.api.dto.req.advert.AdvertRefuseTemplatePageReq;
import cn.com.duiba.tuia.core.api.dto.req.advert.AdvertRefuseTemplateReq;

import java.util.List;

/**
 * 广告拒绝理由模板Remote服务接口
 *
 * @author zhangbaiqiang
 * @date 2020/10/15
 */
@AdvancedFeignClient
public interface RemoteAdvertRefuseTemplateService {

    /**
     * 查询模板数量
     *
     * @param req 参数
     * @return 模板数量
     */
    Integer queryPageCount(AdvertRefuseTemplatePageReq req);

    /**
     * 分页查询模板列表
     *
     * @param req 分页参数
     * @return 模板列表
     */
    List<AdvertRefuseTemplateDto> queryPageList(AdvertRefuseTemplatePageReq req);

    /**
     * 添加模板
     *
     * @param req 参数
     * @return 是否添加成功
     */
    Boolean add(AdvertRefuseTemplateReq req) throws BizException;

    /**
     * 更新模板
     *
     * @param req 参数
     * @return 是否更新成功
     */
    Boolean update(AdvertRefuseTemplateReq req) throws BizException;

    /**
     * 删除模板
     *
     * @param id
     * @return 是否删除成功
     */
    Boolean delete(Long id);

    /**
     * 查询拒绝理由的分类列表
     *
     * @return 分类列表
     */
    List<AdvertRefuseCategoryDto> queryRefuseCategoryList();
}
