package cn.com.duiba.tuia.core.api.remoteservice.compensate;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.compensate.*;
import cn.com.duiba.tuia.core.api.param.CompensatePagingParam;

/**
 * 赔付服务
 *
 * @author peanut.huang
 * @date 2019/10/14
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteCompensateBackendService {

    /**
     * 赔付列表分页查询
     *
     * @param pagingParam
     * @return
     */
    PageDto<CompensateAdvertDTO> pagingList(CompensatePagingParam pagingParam);


    /**
     * 查询赔付配置列表
     *
     * @param advertId 赔付计划id
     * @param compensateDate  赔付日期
     * @return
     */
    List<CompensatePackageDTO> selectPackageList(Long advertId, String compensateDate);

    /**
     * 切换赔付开关
     *
     * @param compensateId  赔付记录id
     * @param targetSwitch  目标开关值
     * @return
     * @throws BizException
     */
    Boolean changSwitch(Long compensateId, Integer targetSwitch) throws BizException;

    /**
     * 查询计划配置内容
     *
     * @param advertId 计划id
     * @return 返回null时说明不要提醒
     */
    String getCompensateRemind(Long advertId);

    /**
     * 分页查询新赔付列表广告维度的数据
     */
    PageDto<CompensateNewAdvertDTO> advertPagingList(CompensatePagingParam pagingParam);

    /**
     * 查询新赔付列表配置维度的数据
     */
    List<CompensateNewPackageDTO> pkgList(Long advertId, String compensateDate);

    /**
     * 新赔付列表导出
     */
    List<CompensateExportDTO> queryListForExport(CompensatePagingParam pagingParam);

    /**
     * 查询广告主的返货赔付使用状态
     *
     * @param accountId 广告主Id
     * @return 返货赔付使用状态 {@link cn.com.duiba.tuia.core.api.enums.compensate.CashBackStateEnum}
     */
    Integer queryCashBackState(Long accountId);
}
