package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import java.util.Date;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertStatisticsDayDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertStatisticsQueryDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetAdvertStatisDataDto;
import cn.com.duiba.tuia.core.api.dto.statistics.DwsAdvertTimesDayDto;
import cn.com.duiba.tuia.core.api.statistics.domain.AdvertStatisticsRsp;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertAppHourDataDto;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertAppHourDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertStatisticsReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertiserDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertiserDataRsp;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAppDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAppDataRsp;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAppHourData;
import cn.com.duiba.tuia.core.api.statistics.domain.GetDailyDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.GetDailyDataRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年06月13日 14:40
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteAdvertAppStatisticsService {

    /**
     * 查询广告统计数据.
     *
     * @param req the req
     * @return AdvertStatisticsDayDO 广告统计信息
     */
    DubboResult<List<AdvertStatisticsRsp>> getAdvertStatisticsByAdvertName(GetAdvertStatisticsReq req);

    DubboResult<List<AdvertStatisticsRsp>> getAdvertStatisticsByAdvertNameNoOrder(GetAdvertStatisticsReq req);

    DubboResult<List<AdvertStatisticsRsp>> getAdvertYesterdayStatisticsByAdvertIds(List<Long> advertids);
    /**
     * 统计广告数据
     * @param req
     * @return
     */
    DubboResult<Integer> getAdvertStatisticsByAdvertNameCount(GetAdvertStatisticsReq req);


    /**
     * 查询广告列表排序分页信息.
     *
     * @param req the req
     * @return the page advert data list
     */
    DubboResult<PageDto<AdvertStatisticsRsp>> getPageAdvertDataList(GetAdvertStatisticsReq req);

    /**
     * 获取每天数据
     * @param req
     * @return
     */
    DubboResult<List<GetDailyDataRsp>> getDailyData(GetDailyDataReq req);

    /**
     * 获取每天数据的总和
     * @param req
     * @return
     */
    DubboResult<Integer> getDailyDataAmount(GetDailyDataReq req);

    DubboResult<Integer> getAppDataAmount(GetAppDataReq req);

    DubboResult<GetAppDataRsp> selectAppCountData(GetAppDataReq req);

    DubboResult<List<GetAppDataRsp>> getAppData(GetAppDataReq req);

    DubboResult<List<GetAppDataRsp>> getAppDailyData(GetAppDataReq req);

    DubboResult<List<GetAdvertAppHourDataDto>> getAdvertAppHourData(GetAdvertAppHourDataReq req);

    List<GetAdvertAppHourDataDto> getAdvertHourAppData(GetAppHourData req);

    DubboResult<Integer> countAppDailyData(GetAppDataReq req);

    DubboResult<Integer> getAdvertDataAmountByDaily(Date startTime, Date endTime, List<Long> advertIds);

    DubboResult<List<AdvertStatisticsDayDto>> getAdvertDataByAccountId(Long accountId, Date startDate, Date endDate);

    @Deprecated
    List<AdvertStatisticsDayDto> getAdvertDataByAgentIdAndMainType(Date startDate, Date endDate, Long agentId, Integer effectiveMainType);
    
    List<AdvertStatisticsDayDto> getAdvertDataByAgentIdsAndMainType(Date startDate, Date endDate, List<Long> agentIds, Integer effectiveMainType);

    List<AdvertStatisticsDayDto> getAdvertDataByAccountIdAndMainType(Long accountId, Date startDate, Date endDate, Integer effectiveMainType);

    List<AdvertStatisticsDayDto> selectCurDateAccountData(List<Long> accountIds, Date curDate);

    /**
     * 查询广告主数据总(条)数.
     *
     * @param req the req
     * @return the statistics
     */
    DubboResult<Integer> getAdvertiserDataAmount(GetAdvertiserDataReq req);

    /**
     * 查询广告主数据.
     *
     * @param req the req
     * @return the daily data
     */
    DubboResult<List<GetAdvertiserDataRsp>> getAdvertiserData(GetAdvertiserDataReq req);

    DubboResult<List<AdvertStatisticsDayDto>> getByAdvertIds(List<Long> advertIds, String startDate, String endDate);

    DubboResult<List<AdvertStatisticsDayDto>> getDailyDateByPage(ReqGetAdvertStatisDataDto getAdvertStatisDataDto);

    DubboResult<List<AdvertStatisticsDayDto>> getListByAdvertIds(ReqGetAdvertStatisDataDto reqGetAdvertStatisDataDto);

    /**
     * 获取代理商的账号
     * @param agentId
     * @return
     */
    DubboResult<Integer> getNumOfConsumeAdvertiser(Long agentId);

    /**
     * 通过itemIds集合去广告数据统计表中查询出每日统计信息
     * @param reqGetAdvertStatisDataDto
     * @return
     */
    DubboResult<List<AdvertStatisticsDayDto>> getDuiabaItemDailyDataByIds(ReqGetAdvertStatisDataDto reqGetAdvertStatisDataDto);


    DubboResult<List<GetDailyDataRsp>> getAdvertStatisticsByIds(GetAdvertStatisticsReq req);
    
    
    /**
     * 
     * getValidAdvertIds:(查询广告数据里的广告id). <br/>
     *
     * @author chencheng
     * @param req
     * @return
     * @since JDK 1.8
     */
    List<Long> getValidAdvertIds(GetAdvertStatisticsReq req);

    /**
     * 代理商后台查询广告数据，汇总查询
     * @param queryDto
     * @return
     */
    List<DwsAdvertTimesDayDto> listGroupByAdvert(AdvertStatisticsQueryDto queryDto);

    /**
     * 代理商后台查询广告数据，分日查询
     * @param queryDto
     * @return
     */
    List<DwsAdvertTimesDayDto> listGroupByAdvertAndCurDate(AdvertStatisticsQueryDto queryDto);
    
    /**
     * 获取实时的应用维度的数据
     * @param req
     * @return
     */
    List<GetAppDataRsp> selectRealTimeData(GetAppDataReq req);
    
    /**
     * 
     * selectAdvertDataByAgentIds:(代理商下的广告数据查询). <br/>
     *
     * @author chencheng
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @param agentIds 代理商id
     * @return
     * @since JDK 1.8
     */
    List<GetAdvertiserDataRsp> selectAdvertDataByAgentIds(String startDate, String endDate, List<Long> agentIds);

    /**
     * 根据日期查询分组数据
     * @param req
     * @return
     */
    List<GetAdvertiserDataRsp> getAdvertiserDataGroupByDate(GetAdvertiserDataReq req);

    /**
     * 获取媒体下广告发券消耗数据（按照媒体和广告分组）
     * @param req
     * @return
     */
    List<GetAppDataRsp> getDataGroupbyAdApp(GetAppDataReq req);

    /**
     * 迁户后,管理后台查询广告数据总数在内存计算
     * @param req
     * @return
     */
    List<AdvertStatisticsRsp> getAfterRelcoAdvertStatisticsByAdvertNameCount(GetAdvertStatisticsReq req);

    /**
     * 迁户数据修复后,管理后台广告主数据
     * @param req
     * @return
     */
    List<GetAdvertiserDataRsp> afterRelcoAdvertiserData (GetAdvertiserDataReq req);

}
