/**
 * Project Name:manager-domain File Name:GetAppDataRsp.java Package Name:cn.com.duiba.tuia.manager.rsp
 * Date:2016年5月25日下午4:50:13 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.rsp.data.AdvertTransformBaseData;

/**
 * ClassName:GetAppDataRsp <br/>
 * Function: 查询应用统计数据返回行数据 <br/>
 * Date: 2016年5月25日 下午4:50:13 <br/>
 * .
 *
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class GetAppDataRsp extends AdvertTransformBaseData {

    private static final long serialVersionUID = -8330341607051141703L;

    /** 开发者ID. */
    private Long   id;

    /** 应用名称. */
    private String name;
    
    /** 应用id*/
    private Long appId;
    
    /** app来源 0-来自兑吧，1-来自媒体平台 */
    private Integer appSource;

    private Date curDate;

    /**
     * 标签名称：行业名称 + 流量标签
     */
    private String tagName;

    /**
     * 行业标签ID
     */
    private Long industryTagId;

    /**
     * 流量标签ID
     */
    private Long flowTagId;
    /**
     * 是否展示加入限流
     */
    private String ifAddLimitApp;
    /**
     * 是否展示移除限流
     */
    private String ifRmLimitApp;


    
    public Long getAppId() {
        return appId;
    }

    
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    
    
    /**
     * appSource.
     *
     * @return  the appSource
     * @since   JDK 1.6
     */
    public Integer getAppSource() {
        return appSource;
    }


    
    /**
     * appSource.
     *
     * @param   appSource    the appSource to set
     * @since   JDK 1.6
     */
    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }


    /**
     * id.
     *
     * @return the id
     * @since JDK 1.7
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id
     * @since JDK 1.7
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * name.
     *
     * @return the name
     * @since JDK 1.7
     */
    public String getName() {
        return name;
    }

    /**
     * name.
     *
     * @param name the name
     * @since JDK 1.7
     */
    public void setName(String name) {
        this.name = name;
    }


    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Long getIndustryTagId() {
        return industryTagId;
    }

    public void setIndustryTagId(Long industryTagId) {
        this.industryTagId = industryTagId;
    }

    public Long getFlowTagId() {
        return flowTagId;
    }

    public void setFlowTagId(Long flowTagId) {
        this.flowTagId = flowTagId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public String getIfAddLimitApp() {
        return ifAddLimitApp;
    }

    public void setIfAddLimitApp(String ifAddLimitApp) {
        this.ifAddLimitApp = ifAddLimitApp;
    }

    public String getIfRmLimitApp() {
        return ifRmLimitApp;
    }

    public void setIfRmLimitApp(String ifRmLimitApp) {
        this.ifRmLimitApp = ifRmLimitApp;
    }
}
