/**
 * Project Name:tuia-advert-manager-common
 * File Name:UrlBase64.java
 * Package Name:cn.com.duiba.tuia.manager.utils
 * Date:2018年3月8日下午5:51:48
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.utils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;

public class UrlBase64 {

    private static Logger logger = LoggerFactory.getLogger(UrlBase64.class);

    public static String urlBase64Encode(String data) {
        try {
            return safeUrlBase64Encode(data.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            logger.error("url base64 encode error", e);
            return StringUtils.EMPTY;
        }
    }

    public static String urlBase64Decode(String data) {
        if (StringUtils.isBlank(data)) {
            return StringUtils.EMPTY;
        }
        try {
            return new String(safeUrlBase64Decode(data), "UTF-8");
        } catch (IOException e) {
            logger.error("url base64 decode error", e);
            return StringUtils.EMPTY;
        }
    }

    private static String safeUrlBase64Encode(byte[] data) {
        String encodeBase64 = Base64.getEncoder().encodeToString(data);
        String safeBase64Str = encodeBase64.replace('+', '-');
        safeBase64Str = safeBase64Str.replace('/', '_');
        safeBase64Str = safeBase64Str.replaceAll("=", "");
        return safeBase64Str;
    }

    private static byte[] safeUrlBase64Decode(final String safeBase64Str) throws IOException {
        String base64Str = safeBase64Str.replace('-', '+');
        base64Str = base64Str.replace('_', '/');
        int mod4 = base64Str.length() % 4;
        if (mod4 > 0) {
            base64Str = base64Str + "====".substring(mod4);
        }
        return Base64.getDecoder().decode(base64Str);
    }

}

