/**
 * Project Name:tuia-advert-web-domain File Name:QualificationRsp.java Package Name:cn.com.duiba.tuia.domain.model.rsp
 * Date:2017年11月27日上午10:54:08 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.rsp.account;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * ClassName:QualificationPackageDto <br/>
 * Function: 资质包信息. <br/>
 * Date: 2019年08月01日 下午4:06:25 <br/>
 *
 * @author lijian
 * @see
 * @since JDK 1.8
 */
@ApiModel("广告主资质信息参数")
public class QualificationPackageDto extends BaseDto {

    private static final long serialVersionUID = -7753082723246783388L;
    @ApiModelProperty("广告主id.")
    private Long advertiserId;

    @ApiModelProperty("资质包名称.")
    private String packageName;

    @ApiModelProperty("资质id列表:英文逗号隔开.")
    private String qualifications;
    @ApiModelProperty("资质id列表")
    private List<QualificationAuditDto> qualificationList;

    @ApiModelProperty("是否异常;0:否；1：是.")
    private Integer abnormal;

    public Long getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getQualifications() {
        return qualifications;
    }

    public void setQualifications(String qualifications) {
        this.qualifications = qualifications;
    }

    public Integer getAbnormal() {
        return abnormal;
    }

    public void setAbnormal(Integer abnormal) {
        this.abnormal = abnormal;
    }

    public List<QualificationAuditDto> getQualificationList() {
        return qualificationList;
    }

    public void setQualificationList(List<QualificationAuditDto> qualificationList) {
        this.qualificationList = qualificationList;
    }
}
